#!/usr/bin/perl

# qdcount.pl
# ---------
# Author : Lordy (http://www.lordy.de)
# Date   : 01/31/2002
# Version: 0.1
#
# Description:
# ------------
# This script reads the output of QMAIL-QREAD and counts the
# queued eMails for each domain. This helps you to figure out
# which domains have been unreachable or spammed.

use strict;

my %queue;
my $domain;

while(<STDIN>) {
  if ($_ =~ /remote/) {
  split (/\@/, $_);
  $domain = $_[1];
  chomp($domain);
  $domain = lc($domain);
  if (defined $queue{$domain}) {
    $queue{$domain} = $queue{$domain} + 1;
  } else {
    $queue{$domain} = 1;
  }
  }
}
close(STDIN);

foreach $domain (sort { $queue{$b} <=> $queue{$a} } keys %queue) {
        print "$domain : $queue{$domain}\n";
}

exit(0);

